require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartCacherPursuit = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartCacherPursuit.MsgBoxCBFuncs = {}

zmediaPoster = Wherigo.ZMedia(cartCacherPursuit)
zmediaPoster.Name="Poster"
zmediaPoster.Description=""
zmediaPoster.AltText=""
zmediaPoster.Id="33818a59-9713-4d79-8d32-515a713fd9f2"
zmediaPoster.Resources = {
{ Type = "jpg", Filename = "poster.jpg", Directives = {},},
}
zmediaEmpty = Wherigo.ZMedia(cartCacherPursuit)
zmediaEmpty.Name="Empty"
zmediaEmpty.Description=""
zmediaEmpty.AltText=""
zmediaEmpty.Id="96c0b32b-8148-4b54-a1f7-327796cc5fe0"
zmediaEmpty.Resources = {
{ Type = "jpg", Filename = "empty.jpg", Directives = {},},
}
zmediaFull = Wherigo.ZMedia(cartCacherPursuit)
zmediaFull.Name="Full"
zmediaFull.Description=""
zmediaFull.AltText=""
zmediaFull.Id="d67c0a05-bfd3-45f9-b78c-8573bf054ebe"
zmediaFull.Resources = {
{ Type = "jpg", Filename = "full.jpg", Directives = {},},
}
zmediaWedge1 = Wherigo.ZMedia(cartCacherPursuit)
zmediaWedge1.Name="Wedge1"
zmediaWedge1.Description=""
zmediaWedge1.AltText=""
zmediaWedge1.Id="089a41e2-8d54-426f-8150-a7c75abe7d15"
zmediaWedge1.Resources = {
{ Type = "jpg", Filename = "wedge1.jpg", Directives = {},},
}
zmediaWedge2 = Wherigo.ZMedia(cartCacherPursuit)
zmediaWedge2.Name="Wedge2"
zmediaWedge2.Description=""
zmediaWedge2.AltText=""
zmediaWedge2.Id="fc2d1d1d-d930-4a39-a267-590f31516f0a"
zmediaWedge2.Resources = {
{ Type = "jpg", Filename = "wedge2.jpg", Directives = {},},
}
zmediaWedge3 = Wherigo.ZMedia(cartCacherPursuit)
zmediaWedge3.Name="Wedge3"
zmediaWedge3.Description=""
zmediaWedge3.AltText=""
zmediaWedge3.Id="a6f64f87-1676-4bea-8a7b-d35daa2f2136"
zmediaWedge3.Resources = {
{ Type = "jpg", Filename = "wedge3.jpg", Directives = {},},
}
zmediaWedge4 = Wherigo.ZMedia(cartCacherPursuit)
zmediaWedge4.Name="Wedge4"
zmediaWedge4.Description=""
zmediaWedge4.AltText=""
zmediaWedge4.Id="ba0c5303-8981-42a1-ace2-f426e60086f4"
zmediaWedge4.Resources = {
{ Type = "jpg", Filename = "wedge4.jpg", Directives = {},},
}
zmediaWedge5 = Wherigo.ZMedia(cartCacherPursuit)
zmediaWedge5.Name="Wedge5"
zmediaWedge5.Description=""
zmediaWedge5.AltText=""
zmediaWedge5.Id="5c2d0807-cdfa-47af-aa49-a07bd8d1db6f"
zmediaWedge5.Resources = {
{ Type = "jpg", Filename = "wedge5.jpg", Directives = {},},
}
zmediaCache = Wherigo.ZMedia(cartCacherPursuit)
zmediaCache.Name="Cache"
zmediaCache.Description=""
zmediaCache.AltText=""
zmediaCache.Id="cca06d69-225d-47e8-a52f-4971e04dd2c2"
zmediaCache.Resources = {
{ Type = "jpg", Filename = "cache.jpg", Directives = {},},
}
zmediaWedge6 = Wherigo.ZMedia(cartCacherPursuit)
zmediaWedge6.Name="Wedge6"
zmediaWedge6.Description=""
zmediaWedge6.AltText=""
zmediaWedge6.Id="912e1258-c1f8-4f0d-9140-ac48b42c4d62"
zmediaWedge6.Resources = {
{ Type = "jpg", Filename = "wedge6.jpg", Directives = {},},
}
zmediaWedge7 = Wherigo.ZMedia(cartCacherPursuit)
zmediaWedge7.Name="Wedge7"
zmediaWedge7.Description=""
zmediaWedge7.AltText=""
zmediaWedge7.Id="38880f8c-d453-4875-a8f3-d337964ca2ef"
zmediaWedge7.Resources = {
{ Type = "jpg", Filename = "wedge7.jpg", Directives = {},},
}
zmediaGameOver = Wherigo.ZMedia(cartCacherPursuit)
zmediaGameOver.Name="GameOver"
zmediaGameOver.Description=""
zmediaGameOver.AltText=""
zmediaGameOver.Id="51bfe0ed-e10a-439b-a739-4da19871182f"
zmediaGameOver.Resources = {
{ Type = "jpg", Filename = "failure.jpg", Directives = {},},
}
-- Cartridge Info --
cartCacherPursuit.Id="f1889fd5-a317-4e20-bf7a-909fe1f453e5"
cartCacherPursuit.Name="Cacher Pursuit"
cartCacherPursuit.Description=[[Answer geocaching trivia questions in this exciting game based on Trivial Pursuit!]]
cartCacherPursuit.Visible=true
cartCacherPursuit.Activity="TourGuide"
cartCacherPursuit.StartingLocationDescription=[[]]
cartCacherPursuit.StartingLocation = ZonePoint(38.9884499867757,-119.207433334986,0)
cartCacherPursuit.Version="1.0"
cartCacherPursuit.Company="Ranger Fox Adventures, Ltd."
cartCacherPursuit.Author="Ranger Fox"
cartCacherPursuit.BuilderVersion="2.0.5129.5086"
cartCacherPursuit.CreateDate="8/26/2015 7:38:56 PM"
cartCacherPursuit.PublishDate="1/1/0001 12:00:00 AM"
cartCacherPursuit.UpdateDate="8/27/2015 9:22:02 PM"
cartCacherPursuit.LastPlayedDate="1/1/0001 12:00:00 AM"
cartCacherPursuit.TargetDevice="PocketPC"
cartCacherPursuit.TargetDeviceVersion="0"
cartCacherPursuit.StateId="1"
cartCacherPursuit.CountryId="2"
cartCacherPursuit.Complete=false
cartCacherPursuit.UseLogging=false
cartCacherPursuit.Media=zmediaPoster
cartCacherPursuit.Icon=zmediaFull

-- Zones --
zoneGeocachingHistory = Wherigo.Zone(cartCacherPursuit)
zoneGeocachingHistory.Id="bae4671e-d06f-4553-b1ee-49d3fd3b3120"
zoneGeocachingHistory.Name="Geocaching History"
zoneGeocachingHistory.Description=[[Questions about the early history of geocaching.]]
zoneGeocachingHistory.Visible=true
zoneGeocachingHistory.DistanceRange = Distance(-1, "feet")
zoneGeocachingHistory.ShowObjects="OnEnter"
zoneGeocachingHistory.ProximityRange = Distance(20, "feet")
zoneGeocachingHistory.AllowSetPositionTo=false
zoneGeocachingHistory.Active=true
zoneGeocachingHistory.Points = {
  ZonePoint(38.98877,-119.20791,0),
  ZonePoint(38.98877,-119.20776,0),
  ZonePoint(38.98866,-119.20776,0),
  ZonePoint(38.98866,-119.20791,0)
}
zoneGeocachingHistory.OriginalPoint = ZonePoint(38.9887166976929,-119.207833337784,0)
zoneGeocachingHistory.DistanceRangeUOM = "Feet"
zoneGeocachingHistory.ProximityRangeUOM = "Feet"
zoneGeocachingHistory.OutOfRangeName = ""
zoneGeocachingHistory.InRangeName = ""

zoneWherigo = Wherigo.Zone(cartCacherPursuit)
zoneWherigo.Id="44fe111b-170c-4c7e-bb8e-b02661da6d01"
zoneWherigo.Name="Wherigo"
zoneWherigo.Description=[[Questions about Wherigo.]]
zoneWherigo.Visible=true
zoneWherigo.DistanceRange = Distance(-1, "feet")
zoneWherigo.ShowObjects="OnEnter"
zoneWherigo.ProximityRange = Distance(20, "feet")
zoneWherigo.AllowSetPositionTo=false
zoneWherigo.Active=true
zoneWherigo.Points = {
  ZonePoint(38.98911,-119.20812,0),
  ZonePoint(38.98911,-119.20798,0),
  ZonePoint(38.98899,-119.20798,0),
  ZonePoint(38.98899,-119.20812,0)
}
zoneWherigo.OriginalPoint = ZonePoint(38.9890499750773,-119.208049996694,0)
zoneWherigo.DistanceRangeUOM = "Feet"
zoneWherigo.ProximityRangeUOM = "Feet"
zoneWherigo.OutOfRangeName = ""
zoneWherigo.InRangeName = ""

zoneCachingTerms = Wherigo.Zone(cartCacherPursuit)
zoneCachingTerms.Id="f0089d17-8f99-4896-ab0b-23438dcbeb56"
zoneCachingTerms.Name="Caching Terms"
zoneCachingTerms.Description=[[Questions about geocaching terminology.]]
zoneCachingTerms.Visible=true
zoneCachingTerms.DistanceRange = Distance(-1, "feet")
zoneCachingTerms.ShowObjects="OnEnter"
zoneCachingTerms.ProximityRange = Distance(20, "feet")
zoneCachingTerms.AllowSetPositionTo=false
zoneCachingTerms.Active=true
zoneCachingTerms.Points = {
  ZonePoint(38.98937,-119.20781,0),
  ZonePoint(38.98937,-119.20766,0),
  ZonePoint(38.98926,-119.20766,0),
  ZonePoint(38.98926,-119.20781,0)
}
zoneCachingTerms.OriginalPoint = ZonePoint(38.9893166859945,-119.207733329137,0)
zoneCachingTerms.DistanceRangeUOM = "Feet"
zoneCachingTerms.ProximityRangeUOM = "Feet"
zoneCachingTerms.OutOfRangeName = ""
zoneCachingTerms.InRangeName = ""

zoneGeocachers = Wherigo.Zone(cartCacherPursuit)
zoneGeocachers.Id="ccddb4da-8a5c-4dcb-8e6e-7db5f8c98787"
zoneGeocachers.Name="Geocachers"
zoneGeocachers.Description=[[Questions about geocachers.]]
zoneGeocachers.Visible=true
zoneGeocachers.DistanceRange = Distance(-1, "feet")
zoneGeocachers.ShowObjects="OnEnter"
zoneGeocachers.ProximityRange = Distance(20, "feet")
zoneGeocachers.AllowSetPositionTo=false
zoneGeocachers.Active=true
zoneGeocachers.Points = {
  ZonePoint(38.98926,-119.20774,0),
  ZonePoint(38.98926,-119.20759,0),
  ZonePoint(38.98914,-119.20759,0),
  ZonePoint(38.98914,-119.20774,0)
}
zoneGeocachers.OriginalPoint = ZonePoint(38.9892000198364,-119.207666667302,0)
zoneGeocachers.DistanceRangeUOM = "Feet"
zoneGeocachers.ProximityRangeUOM = "Feet"
zoneGeocachers.OutOfRangeName = ""
zoneGeocachers.InRangeName = ""

zonePlaces = Wherigo.Zone(cartCacherPursuit)
zonePlaces.Id="2ed8d3df-ddff-4349-981d-3778488305fc"
zonePlaces.Name="Places"
zonePlaces.Description=[[Questions about places with geocaches.]]
zonePlaces.Visible=true
zonePlaces.DistanceRange = Distance(-1, "feet")
zonePlaces.ShowObjects="OnEnter"
zonePlaces.ProximityRange = Distance(20, "feet")
zonePlaces.AllowSetPositionTo=false
zonePlaces.Active=true
zonePlaces.Points = {
  ZonePoint(38.98891,-119.20751,0),
  ZonePoint(38.98891,-119.20736,0),
  ZonePoint(38.98879,-119.20736,0),
  ZonePoint(38.98879,-119.20751,0)
}
zonePlaces.OriginalPoint = ZonePoint(38.9888500213623,-119.207433334986,0)
zonePlaces.DistanceRangeUOM = "Feet"
zonePlaces.ProximityRangeUOM = "Feet"
zonePlaces.OutOfRangeName = ""
zonePlaces.InRangeName = ""

zoneChallenges = Wherigo.Zone(cartCacherPursuit)
zoneChallenges.Id="99f1d028-8169-46fa-ae28-9e5d1f98fe01"
zoneChallenges.Name="Challenges"
zoneChallenges.Description=[[Questions about challenge caches.]]
zoneChallenges.Visible=true
zoneChallenges.DistanceRange = Distance(-1, "feet")
zoneChallenges.ShowObjects="OnEnter"
zoneChallenges.ProximityRange = Distance(20, "feet")
zoneChallenges.AllowSetPositionTo=false
zoneChallenges.Active=true
zoneChallenges.Points = {
  ZonePoint(38.98871,-119.20741,0),
  ZonePoint(38.98871,-119.20726,0),
  ZonePoint(38.98859,-119.20726,0),
  ZonePoint(38.98859,-119.20741,0)
}
zoneChallenges.OriginalPoint = ZonePoint(38.988650004069,-119.20733332634,0)
zoneChallenges.DistanceRangeUOM = "Feet"
zoneChallenges.ProximityRangeUOM = "Feet"
zoneChallenges.OutOfRangeName = ""
zoneChallenges.InRangeName = ""

zoneFullPie = Wherigo.Zone(cartCacherPursuit)
zoneFullPie.Id="a4a85da3-3bf7-4506-a198-73ad0878a078"
zoneFullPie.Name="Full Pie"
zoneFullPie.Description=[[This is the final cache.  It is not a micro ammo can.  It's a standard container for around here.]]
zoneFullPie.Visible=true
zoneFullPie.DistanceRange = Distance(-1, "feet")
zoneFullPie.ShowObjects="OnEnter"
zoneFullPie.ProximityRange = Distance(20, "feet")
zoneFullPie.AllowSetPositionTo=false
zoneFullPie.Active=false
zoneFullPie.Points = {
  ZonePoint(38.9887,-119.2072,0),
  ZonePoint(38.9887,-119.20713,0),
  ZonePoint(38.98864,-119.20713,0),
  ZonePoint(38.98864,-119.2072,0)
}
zoneFullPie.OriginalPoint = ZonePoint(38.9886666615804,-119.207166671753,0)
zoneFullPie.DistanceRangeUOM = "Feet"
zoneFullPie.ProximityRangeUOM = "Feet"
zoneFullPie.OutOfRangeName = ""
zoneFullPie.InRangeName = ""
zoneFullPie.Media=zmediaCache
zoneFullPie.Icon=zmediaCache

-- Characters --

-- Items --
zitemWedgesEarned = Wherigo.ZItem(cartCacherPursuit)
zitemWedgesEarned.Id="145b52d5-7088-4073-869c-99c6b18845e1"
zitemWedgesEarned.Name="Wedges Earned"
zitemWedgesEarned.Description=[[]]
zitemWedgesEarned.Visible=true
zitemWedgesEarned.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemWedgesEarned.Locked = false
zitemWedgesEarned.Opened = false

zitemCompletionCode = Wherigo.ZItem(cartCacherPursuit)
zitemCompletionCode.Id="245b52d5-7088-4073-869c-99c6b18845e1"
zitemCompletionCode.Name="Completion Code"
zitemCompletionCode.Description=[[The cartridge is complete.  Your completion code is {0}.  Use it to unlock the cartridge on wherigo.com.]]
zitemCompletionCode.Visible=true
zitemCompletionCode.ObjectLocation = Wherigo.INVALID_ZONEPOINT
zitemCompletionCode.Locked = false
zitemCompletionCode.Opened = false

-- Tasks --

-- Cartridge Variables --
answer = ""
cartCacherPursuit.ZVariables = {answer = ""}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.answer = {}
buildervar.answer.Id ="f8b7042b-cbcb-48dd-8a67-7d204449c072"
buildervar.answer.Name = "answer"
buildervar.answer.Type = "String"
buildervar.answer.Data=[[]]
buildervar.answer.Description=[[]]


-- ZTimers --

-- Inputs --
zinputQuestion = Wherigo.ZInput(cartCacherPursuit)
zinputQuestion.Id="59139e0a-6a3b-4685-aa82-561629c2a901"
zinputQuestion.Name="Question"
zinputQuestion.Description=[[Generic question input]]
zinputQuestion.Visible=true
zinputQuestion.InputType="Text"
zinputQuestion.InputVariableId="f8b7042b-cbcb-48dd-8a67-7d204449c072"
zinputQuestion.Text=[[Reserved for the question.]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --


--
--	CACHER PURSUIT
--		A Wherigo cartridge by Ranger Fox, 2015
--
--		Creative Commons
--			This is released under Creative Commons for non-commercial use.  You can modify this cartridge as long as you share alike and attribute me as its original author.
--
--		This cartridge is designed to be modified easily in notepad.  The messages section is shown below.  You can modify or translate the messages to fit your game.
--		Also, there is a demo mode in this cartridge.  If anyone plays it in the emulator, they will only be able to play the first two zones.  That will allow players to get
--			a feel for the cartridge before going out into the field.  If you do not want people to play the cartridge at all, set this number to zero.
--		The next section is Init().  There is a lot of documention there.  This is where you define your question bank.  The question bank is composed of the QGROUP and its questions.
--		You can have as many zones as you want in your game.
--



--Messages shown to the user.  You can customize these.
StartGameMessage = [[Welcome to Cacher Pursuit!

This game is reminiscent of Trivial Pursuit, but with a geocaching theme.  Each location has a different subject matter, indicated by the location's name.  When you arrive at a location, you will be asked a random question.  If you get it right, you get a wedge for your pie.  If you answer incorrectly, however, you'll have to visit another location before attempting the subject again.

The game ends when you either gather all pie wedges or exhaust your opportunities to answer questions for a category.  The location for the final geocache can be accessed only when you gather all pie wedges.

Good luck!]]
StartGameMedia = zmediaEmpty
GameCompleteMessage = [[You found all wedges!  Treat yourself to some pie--or just go to the cache!]]
GameCompleteMedia = zmediaFull
GameOverMedia = zmediaGameOver
AttemptsRemainingText = [[Attempts Remaining: {0}]]
WedgesEarnedText = [[Wedges Earned: {0}]]
DemoModeZoneCount = 2	--To allow the cartridge to be played completely, just set this number to a number more than the total number of question categories (zones) you have.
DemoModeMessage = [[Thank you for playing this cartridge in demo mode.  You now know what to expect when you play it in the field.  Please do so.]]


-- This initializes the question bank.
function Init()

    --How to add a new question group (category):
    --    Copy the code from one group and modify the zone, group category, and messages associated with the group.  Change the questions as well.  Just follow the pattern already established.
    --        In addition, when you add a zone, do not forget to add the zone OnEnter event to the group below this function.
    --    This game can have as many question groups and questions as you would like.  There is no limit.  As this is stored in memory, too many questions might slow some devices.  I am not too concerned
    --        about that issue, though, as this is all text, thereby being lightweight.

    --Question Group Object:
    --    Zone - zone object.  This is the zone paired with this question group.  When the player enters this zone, questions from this group will be asked.
    --    Category - Text.  This tells us the category name for the question group.
    --    Questions - Question Object.  This is where we store the questions for this group.
    --    MaxAttempts - Number.  This is the maximum number of attempts a player can make to answer this question group.  The player loses when either this number is reached or there are no more questions to ask.
    --    Complete - True/false.  This always needs to be set to false.  When the player answers a question in this group correctly, this is set to true to indicate that.  When all question group Completes have been set to true, the player wins.
    --    SuccessMessage - Text.  A message to show when the player correctly answers a question.
    --    IncorrectMessage - Text.  A message to show when the player does not answer a question correctly.  This is not shown if the player runs out of retries; the GameOverMessage is shown instead.
    --    GameOverMessage - Text.  A message to show when the player fails at winning a wedge here, thus ending the game.  Feel free to taunt the player.

    --Question Object:
    --    Type - MC/OA.  This tells whether the question is multiple choice (MC) or open-ended (OA).
    --    IsAsked - True/false.  This is how we track whether a question has been asked.  Always set this to false.  Anything set to true will be counted against the retry attempts given to the player.
    --    Question - Text.  This is the question that will be asked.
    --    Options - Text list.  When the question is multiple choice, these are the choices given to the player.  When the question is open-ended, this will be ignored.
    --    Answers - Text list.  This is a list of correct answers that will be accepted.  It is a list so you can count all abbreviations, pluralty, or misspellings as correct answers.  It is not case-sensitive.


    local allQuestionGroups = {}

    local qgroup = nil
    local q = nil

    --Caching Terms
    qgroup = { Zone = zoneCachingTerms, ID = 1, Category = "Caching Terms", Questions = {}, MaxAttempts = 99, Complete = not zoneCachingTerms.Active, WedgeMedia=zmediaWedge1, SuccessMessage = "Great!  You earned a pie wedge!", IncorrectMessage = "That's incorrect.  Try another question.", GameOverMessage = "Guess you need to get out a dictionary.  Game Over." }
    table.insert(allQuestionGroups, qgroup)
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "What event is normally held in April?", Options = { "CITO", "Geowoodstock", "Geobash"}, Answers = {"CITO"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "The geodetic discs fall under what category?", Answers = {"Benchmark", "Benchmarks"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "This term used when a cache has been discontinued.", Answers = {"Archived", "Archive"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = [[The word "geo" in "geocaching" means what?]], Answers = {"earth"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = [[UTM is another coordinate format.  What does the "M" stand for?]], Answers = {"mercator"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Geocache hints are encrypted using what format?", Answers = {"rot","rot13"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Finding at least one cache a day, every day, without missing a day is commonly refered to as a _______?", Answers = {"streak","geostreak"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Which geocache type was eventually spun off as waymarking.com?", Answers = {"locationless", "virtual", "virtuals"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "What GPS security feature was disabled, which led to the rise of geocaching?  (An abbreviation is fine.)", Answers = {"SA","selective availbility"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "FTL typically means you're the first to do what?", Answers = {"lose"} })

    --Challenges
    qgroup = { Zone = zoneChallenges, ID = 2, Category = "Challenges", Questions = {}, MaxAttempts = 99, Complete = not zoneChallenges.Active, WedgeMedia=zmediaWedge2, SuccessMessage = "Excellent!  You got the challenge cache wedge!", IncorrectMessage = "Nope.  Let's try another question.", GameOverMessage = "Looks like this was too challenging for you.  Game Over." }
    table.insert(allQuestionGroups, qgroup)
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "The Well-Rounded Cacher Challenge was originally called the ______ challenge?", Options = { "81", "Fizzy", "Completionist" }, Answers = {"Fizzy"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In what year were challenge caches discontinued?", Answers = {"2015"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Visiting all pages in an atlas for a state is called the ______ challenge.", Answers = {"DeLorme"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Geocaching.com has a list of milestones for each geocacher.  The first milestone is the geocacher's first find.  What is the eighth?", Answers = {"200","two hundred"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "The challenge of finding caches that haven't been found in a while is called The _______ Cache Challenge?", Answers = {"Lonely"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "The challenge of finding caches published on each month of each year is called the _____ Challenge.", Answers = {"Jasmer","Jazmer"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = [[Which state's DeLorme Challenge is known as "The Minor Inconvenience"?]], Answers = {"RI", "Rhode Island"} })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "An icon challenge is also known as a _____ _____ challenge.", Answers = {"busy day"} })

    --Geocachers
    qgroup = { Zone = zoneGeocachers, ID = 3, Category = "Geocachers", Questions = {}, MaxAttempts = 99, Complete = not zoneGeocachers.Active, WedgeMedia=zmediaWedge3, SuccessMessage = "All right!  Looks like you know some names!  You got a pie wedge!", IncorrectMessage = "Not quite.  See if you can answer another question.", GameOverMessage = "You might need to drag out a Who's Who before trying again.  Game Over." }
    table.insert(allQuestionGroups, qgroup)
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who was the number one geocacher in the world around 2006?", Options = { "Team Alamo", "Bobcam", "CCCooperAgency" }, Answers = {"CCCooperAgency"} })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who was the Well-Rounded Cacher Challenge in honor of?", Options = { "Grand High Poobah", "FizzyMagic", "tentha" }, Answers = { "FizzyMagic" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who created the first geocoin?", Options = { "Groundspeak", "f0t0m0m", "Moun10bike" }, Answers = { "Moun10bike" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Most geocaches in Yerington, NV have been placed by which team?", Options = { "Tumbleweeds", "Sagebrushers", "Jeep4x4", "HiDesert" }, Answers = { "Sagebrushers" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which Groundspeak founder is not currently involved in the company's day-to-day activities?", Options = { "Bryan", "Elias", "Jeremy" }, Answers = { "Elias" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which Groundspeak founder is responsible for business development?", Options = { "Bryan", "Elias", "Jeremy" }, Answers = { "Bryan" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which of these geocachers has placed a lot of geocaches around Yerington?", Options = { "Two Left Knees", "tentha", "Bobcam", "Tumbleweeds" }, Answers = { "Two Left Knees" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which of these geocachers has the most FTFs due to all the caches in Yerington?", Options = { "Two Left Knees", "macjohnnv", "Bobcam", "hockabee" }, Answers = { "macjohnnv" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who placed the oldest cache in Nevada?  This account has only two placements and no finds.", Options = { "DS", "Opa Fritz", "explorer", "L3-Geo" }, Answers = { "DS" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who was the first cacher to find the oldest cache in Nevada?.", Options = { "DS", "Opa Fritz", "explorer", "L3-Geo" }, Answers = { "explorer" } })

    --Geocaching History
    qgroup = { Zone = zoneGeocachingHistory, ID = 4, Category = "Geocaching History", Questions = {}, MaxAttempts = 99, Complete = not zoneGeocachingHistory.Active, WedgeMedia=zmediaWedge4, SuccessMessage = "Cool!  You know some history and got a pie wedge!", IncorrectMessage = "Nope.  That question is history.  Let's try another.", GameOverMessage = "Looks like you're history.  Game Over." }
    table.insert(allQuestionGroups, qgroup)
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In what year was the first geocache placed?", Answers = { "2000" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "What is the name of the oldest geocache in Kansas?", Answers = { "Mingo", "GC30" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which is the newest geocache type?", Options = { "Multi", "CITO", "Mystery" }, Answers = { "CITO" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who hid the first geocache?", Options = { "Matt Foust", "Dave Ulmer", "Matt Stum" }, Answers = { "Dave Ulmer" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Before it was called a geocache, what was it called?", Answers = { "stash", "geostash" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = [[Who came up with the name "geocache"?]], Options = { "Matt Foust", "Dave Ulmer", "Matt Stum" }, Answers = { "Matt Stum" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = [[Around how long was it after the first cache was hidden before the name "geocache" was proposed?]], Options = { "1 week", "1 month", "6 months", "1 year" }, Answers = { "1 month" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "When selective availability was on, about how accurate was a GPS fix?", Options = { "100 feet", "200 feet", "300 feet", "400 feet" }, Answers = { "300 feet" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "How many days did it take for the first FTF of the first geocache?", Answers = { "3", "three" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = [[What plastic container was used for the lowest geocache, "Rainbow Hydrothermal Vents"?]], Options = { "Ammo Can", "Horse", "Anchor", "Chest" }, Answers = { "Horse" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "What Victorian pastime was the precursor of geocaching?", Answers = { "letterbox", "letterboxing" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who did geocaching.com partner with for the first TB promotion?", Options = { "20th Century Fox", "Geico", "Jeep", "Disney" }, Answers = { "Jeep" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "What was the original name of the company that hosted geocaching.com?", Answers = { "Grounded", "Grounded, Inc", "Grounded, Inc.", "Grounded Inc", "Grounded Inc." } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "How many shirts were originally sold by the founders to fund the launch of geocaching.com?", Options = { "33", "1549", "144", "354" }, Answers = { "144" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "When geocaching.com first launched, how many geocaches were listed on the website?", Options = { "178", "34", "75", "12" }, Answers = { "75" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In what year was the first trackable geocoin created?", Answers = { "2001" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Signal the Frog was introduced in August of which year?", Answers = { "2003" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In what year were geocaching attributes added?", Answers = { "2005" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Locationless caches were discontinued on January of which year?", Answers = { "2006" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In what year was the last block party event held in Washington?", Answers = { "2015" } })

    --Places
    qgroup = { Zone = zonePlaces, ID = 5, Category = "Places", Questions = {}, MaxAttempts = 99, Complete = not zonePlaces.Active, WedgeMedia=zmediaWedge5, SuccessMessage = "Nice!  You got a pie wedge.  Do you have your next trip planned?", IncorrectMessage = "That's not right.  Try another question.", GameOverMessage = "Looks like you won't find this cache's place, either.  Game Over." }
    table.insert(allQuestionGroups, qgroup)
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which country has the most geocaches?", Options = { "Germany", "Czech Republic", "USA" }, Answers = { "USA" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In Nevada, which town has the most geocaches?", Options = { "Alamo", "Searchlight", "Yerington" }, Answers = { "Yerington" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In which state is Groundspeak headquartered?", Answers = { "WA", "Washington" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which city used geocaching to promote its King Tut display?", Options = { "Chicago", "Philadelphia", "Washington, D.C." }, Answers = { "Philadelphia" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Where was the first geocaching event held?", Options = { "Chicago, IL", "Seattle, WA", "Austin, TX", "Newark, NJ" }, Answers = { "Austin, TX" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "The first earthcache was hidden in which country?", Options = { "Australia", "Germany", "USA", "France" }, Answers = { "Australia" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "The first mega event was held where?", Options = { "Hamburg", "Saxony", "Texas", "Washington" }, Answers = { "Texas" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Where has geocoinfest not been held?", Options = { "Rock Hill", "Denver", "Phoenix", "Omaha" }, Answers = { "Phoenix" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Alaska is the northernmost state in the US.  In which of its towns is the northernmost geocache?", Options = { "Atqasuk", "Barrow", "North Pole", "Prudhoe Bay" }, Answers = { "Barrow" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "Which town in the continental United States has the southernmost geocache?", Answers = { "Key West" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In which state was the first Geowoodstock held?", Answers = { "Kentucky", "KY" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In which country is the last remaining Project A.P.E. cache?", Answers = { "Brazil", "Brasil" } })

    --Wherigo
    qgroup = { Zone = zoneWherigo, ID = 6, Category = "Wherigo", Questions = {}, MaxAttempts = 99, Complete = not zoneWherigo.Active, WedgeMedia=zmediaWedge7, SuccessMessage = "Good!  You're playing Wherigo, so it's good to know a little about it.  You got a pie wedge.", IncorrectMessage = "Nope.  Let's see if you know something else.", GameOverMessage = "Looks like you don't know Wherigo enough.  Game Over." }
    table.insert(allQuestionGroups, qgroup)
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Ranger Fox officially demonstrated which Wherigo cartridge to the attendees at Geowoodstock VI?", Options = { "Whack-A-Lackey", "Battleship", "Sample Clue Hunt", "Wherigo Tutorial" }, Answers = { "Whack-A-Lackey" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In Wherigo, a location is called a _____ ?", Answers = { "Zone", "Zones" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "What is the name of the international Wherigo platform development group Ranger Fox formed in December 2013?", Answers = { "WF", "Wherigo Foundation", "Whereigo Foundation", "The Wherigo Foundation" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who is not a member of the Wherigo Foundation?", Options = { "matejcik", "Mangatome", "Kluso" }, Answers = { "Kluso" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "What is one of the online builders called?", Options = { "Webwigo", "Urwigo", "Earwigo" }, Answers = { "Earwigo" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "In what year was the Wherigo Foundation established?", Answers = { "2013" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which is not a Wherigo object?", Options = { "Timer", "Media", "Clip", "Task" }, Answers = { "Clip" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Which is not a zone event?", Options = { "Distant", "Proximity", "Leave", "Enter" }, Answers = { "Leave" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "The first non-Groundspeak Wherigo cartridge was placed in which state?", Options = { "Oregon", "Texas", "Wisconsin", "Washington" }, Answers = { "Wisconsin" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "When launched, Wherigo cartridges fell under which geocache type?", Options = { "Multi", "Mystery", "Wherigo" }, Answers = { "Mystery" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "Who created the first play-anywhere cartridge to have a physical geocache associated with it?", Options = { "delta123", "J2B2", "Ranger Fox", "Touchstone" }, Answers = { "Ranger Fox" } })
    table.insert(qgroup.Questions, { Type = "MC", IsAsked = false, Question = "What was the first play-anywhere cartridge to have a physical geocache associated with it?", Options = { "Whack-A-Lackey", "Battleship", "Ketelbinkie", "A Vegas Riddle" }, Answers = { "Whack-A-Lackey" } })
    table.insert(qgroup.Questions, { Type = "OA", IsAsked = false, Question = "What will crash the Wherigo server if put it in your online cartridge description?  It's fine to have this in your geocache description, however.", Answers = { "HTML" } })


    QuestionBank = allQuestionGroups


    for x=1, #QuestionBank do
        SetZoneAttempts(QuestionBank[x])
        local z = QuestionBank[x].Zone

	--If you want to set the zone to use OnEnter or OnProximity, you can do it here.
	--  Note: I needed to set the zone to a local variable so I could reference it within the lambda expression (anonymous function).
        z.OnProximity = function()
            ZoneEntered(z)
        end
    end

    zitemWedgesEarned:MoveTo(Player)
    SetWedgesEarned()
    

    --Testing for demo mode
    if IsEmulator() and DemoModeZoneCount >= 0 then
        --This is the emulator, but the author wants the player to play through some zones.  We will allow the first X zones to be playable.

        for x=DemoModeZoneCount + 1, #QuestionBank do
            QuestionBank[x].Zone.Active = false
            QuestionBank[x].Complete = false
        end

        --The author does not want any zones playable.  The above statement will disable all zones, so all we need to do now is show the demo mode message to the player.
        if DemoModeZoneCount == 0 then
            Wherigo.MessageBox{Text=DemoModeMessage,}
        end
    end

end


-- ------------------------------------------
--  You do not need to edit below this line
-- ------------------------------------------

--The fun list of variables (private; do not edit these)
QuestionBank = nil
CurrentZone = nil
CurrentQuestionGroup = nil
CurrentQuestion = nil


--Triggers when the cartridge starts.  This sets some things up and greets the player.
function cartCacherPursuit:OnStart()
    Init()

    Wherigo.MessageBox{Text=StartGameMessage,Media=StartGameMedia,}
end

function cartCacherPursuit:OnRestore()
    Init()
end


--A generic event to handle when a player enters a zone.
function ZoneEntered(zone)
    --If there is a question in progress, exit.  This is how we avoid the Garmin multiple input crashing bug.
    if CurrentQuestionGroup ~= nil then
        return
    end

    --The previous zone should be shown (if there is one, that means the player answered the last question incorrectly), then we should remember this zone.
    zone.Active = false
    if CurrentZone ~= nil then
        CurrentZone.Active = true
    end
    CurrentZone = zone

    --Now, ask a question
    AskQuestion(zone)
end



--The main function to call when you want to ask a question.  The QuestionID is actually the question group ID.
function AskQuestion(zone)

    local qgroup = FindQuestion(zone)
    if qgroup == nil then
        return
    end
    CurrentQuestionGroup = qgroup


    local x
    local unaskedQuestions = {}

    --It is a little easier if we store the indicies of the unasked questions.  Too bad I do not have LINQ.
    for x=1, #qgroup.Questions do
        if qgroup.Questions[x].IsAsked == false then
            table.insert(unaskedQuestions, x)
        end
    end



    --If we do not have unasked questions, we should not even be here.  Do the game over routine.
    if #unaskedQuestions == 0 then
        GameOver(zone)
        return
    end

    --Choose a random question to ask
    x = math.random(1,#unaskedQuestions)
    CurrentQuestion = qgroup.Questions[x]

    CurrentQuestion.IsAsked = true
    zinputQuestion.Text = CurrentQuestion.Question
    --zinputQuestion.Choices = nil   --This used to crash the iOS app.  I do not know if it will now.

    if CurrentQuestion.Type == "OA" then
        zinputQuestion.InputType = "Text"
    else
	zinputQuestion.Choices = CurrentQuestion.Options
        zinputQuestion.InputType = "MultipleChoice"
    end

    Wherigo.GetInput(zinputQuestion)
end


--Finds a question group from ID
function FindQuestion(zone)

    local x
    local qgroup = nil

    --Find the question group
    for x=1, #QuestionBank do
        if QuestionBank[x].Zone == zone then
            qgroup = QuestionBank[x]
            break
        end
    end

    --It is an error if we cannot find the question group.
    if qgroup == nil then
        Wherigo.MessageBox{Text="The zone " .. zone.Name .. " did not have a question group associated with it in the question bank.  This is an error." }
        return nil
    end

    return qgroup
end

function zinputQuestion:OnGetInput(input)
    QuestionAnswered(input)
end

--When the player provides an answer to the generic input, we get it here.
function QuestionAnswered(input)
    if input == nil then
        return
    end

    local answer = input
    local iscorrect = false
    local x

    --Checking to see if that is the right answer.
    for x=1,#CurrentQuestion.Answers do
        if Wherigo.NoCaseEquals(answer, CurrentQuestion.Answers[x]) then
            iscorrect = true
            break
        end
    end

    --If the answer is correct, we mark the group as complete and show the success message, then we test (as a callback) to see if the player has completed the game.
    if iscorrect then
        CurrentQuestionGroup.Complete = true
        Wherigo.MessageBox{Text=CurrentQuestionGroup.SuccessMessage,Callback=WedgeAwarded,Media=CurrentQuestionGroup.WedgeMedia,}
        return
    end

    --We are trying to see how many questions remain unasked.  This will determine if it is game over or the player can try again later.
    local unaskedcount = 0
    for x=1, #CurrentQuestionGroup.Questions do
        if CurrentQuestionGroup.Questions[x].IsAsked == false then
            unaskedcount = unaskedcount + 1
        end
    end

    --We now test for the game over condition.  The game is over if the player runs out of questions to answer or the question group MaxAttempts is reached.
    if unaskedcount == 0 or CurrentQuestionGroup.MaxAttempts <= #CurrentQuestionGroup.Questions - unaskedcount then
        GameOver(CurrentZone)
    else
        Wherigo.MessageBox{Text=CurrentQuestionGroup.IncorrectMessage,Callback=AskNextQuestion}
        SetZoneAttempts(CurrentQuestionGroup)
    end
end


--This is called when the player answers a question correctly.
function WedgeAwarded()
    --Clearing cached pointers
    CurrentQuestionGroup = nil
    CurrentZone = nil

    local allcomplete = true
    local x
    local completeCount = 0

    SetWedgesEarned()

    --Do we have a winner?
    for x=1, #QuestionBank do
        if QuestionBank[x].Complete == false then
            allcomplete = false
        else
            completeCount = completeCount + 1
        end
    end

    --Testing for demo mode
    if IsEmulator() and DemoModeZoneCount <= completeCount then
        Wherigo.MessageBox{Text=DemoModeMessage,}
        return
    end

    --If the player has not gotten all wedges, we do not do anything.
    if allcomplete == false then
        return
    end

    --This is called when the player has earned all wedges.
    Wherigo.MessageBox{Text=GameCompleteMessage,Media=GameCompleteMedia,}
    zoneFullPie.Visible = true
    zoneFullPie.Active = true
    zitemCompletionCode.Description = string.gsub(zitemCompletionCode.Description, "{0}", Player.CompletionCode)
    zitemCompletionCode:MoveTo(Player)
end


--Call this to ask the next available question in a question group.
function AskNextQuestion()
    --AskQuestion(CurrentQuestionGroup.ID)

    --Is this the last zone?
    local x
    local unansweredCount = 0
    for x=1, #QuestionBank do
        if QuestionBank[x].Complete == false then
            unansweredCount = unansweredCount + 1
        end
    end


    --The first test is to see if there are more zones available to be answered.  If not, we should just display another question.
    --The second test is to adjust for the count if the user is playing it in demo mode on the emulator.
    if unansweredCount > 1 and (not IsEmulator() or #QuestionBank ~= unansweredCount + DemoModeZoneCount - 1) then
        CurrentQuestionGroup = nil
    else
        --This is the only zone.  Ask the next question.
        AskQuestion(CurrentZone)
    end
end


function SetZoneAttempts(qgroup)
    local unaskedcount = 0
    for x=1, #qgroup.Questions do
        if qgroup.Questions[x].IsAsked == false then
            unaskedcount = unaskedcount + 1
        end
    end

    local remaining = 0
    if qgroup.MaxAttempts > #qgroup.Questions then
        remaining = unaskedcount
    else
        remaining = qgroup.MaxAttempts - (#qgroup.Questions - unaskedcount)
    end

    qgroup.Zone.Description = string.gsub(AttemptsRemainingText, "{0}", remaining .. "")
end

function SetWedgesEarned()
    local x
    local completed = 0

    --Do we have a winner?
    for x=1, #QuestionBank do
        if QuestionBank[x].Complete then
            completed = completed + 1
        end
    end

    zitemWedgesEarned.Name = string.gsub(WedgesEarnedText, "{0}", completed .. "")
    zitemWedgesEarned.Description = zitemWedgesEarned.Name
end

--This is called when the player loses the game.
function GameOver(zone)
    local qgroup = FindQuestion(zone)
    if qgroup ~= nil then
        Wherigo.MessageBox{Text=qgroup.GameOverMessage,Media=GameOverMedia,}
    end

    local allZones = cartCacherPursuit:GetAllOfType('Zone')
    for _,z in ipairs(allZones) do
        z.Active = false
    end

    CurrentQuestionGroup = nil
end



function IsEmulator()
    --Yes, I meant to write it like this.  Doing it this way is a little more challenging if someone messes with the hex code.
    local did = gsub_wig(string.lower(Env.DeviceID))
    if did ~= "m2v52@xw" and did ~= "mo3w624-rq" and did ~= "nw5xn737" and did ~= "nw3o4w49nx" and did ~= "5om8vu3" and did ~= "k1z85s6" and did ~= "mo3w624" then
        --Not playing on an emulator
        return false
    end
    return true
end


function gsub_wig (str, obf)
local result = ""
if (obf == nil) then
obf = true
end
local rot_palette = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@.-~"
local plen = string.len(rot_palette)
local magic = { ["\001"] = "B"; ["\002"] = "R"; ["\003"] = "" }
str = string.gsub(str, "\038nbsp;", " ")
for i = 1, string.len(str) do
local c = string.sub(str, i, i)
local p = string.find(rot_palette, c, 1, true)	-- true -> plain text search
if (p) then
local jump = (i-1) % 8 + 9
if (obf) then
p = p + jump
if (p > plen) then
p = p - plen
end
else
p = p - jump
if (p < 1) then
p = p + plen
end
end
c = string.sub(rot_palette, p, p)		--(debug) .. "(" .. string.byte(c) .. ")"
else
x = magic[c]
if (x) then
c = x					--(debug) .. "(*)"
else
--(debug) c = c .. "(=" .. string.byte(c) .. ")"
end
end
result = result .. c			--(debug) .. "[i=" .. i .. "]"
end
return result
end
-- #End Author Functions# --
-- Nothing after this line --
return cartCacherPursuit
